<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=5, user-scalable=1" name="viewport"/>

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <!-- Fonts-->
    <link href="https://fonts.googleapis.com/css?family=<?php echo e(urlencode(theme_option('primary_font', 'Work Sans'))); ?>:300,400,500,600,700&amp;amp;subset=latin-ext" rel="stylesheet" type="text/css">
    <!-- CSS Library-->

    <style>
        :root {
            --color-1st: <?php echo e(theme_option('primary_color', '#fcb800')); ?>;
            --color-2nd: <?php echo e(theme_option('secondary_color', '#222222')); ?>;
            --primary-font: '<?php echo e(theme_option('primary_font', 'Work Sans')); ?>', sans-serif;
        }
    </style>

    <?php echo Theme::header(); ?>

</head>
<body <?php if(BaseHelper::siteLanguageDirection() == 'rtl'): ?> dir="rtl" <?php endif; ?> <?php if(Theme::get('pageId')): ?> id="<?php echo e(Theme::get('pageId')); ?>" <?php endif; ?>>
<div class="ps-page--comming-soon">
    <div class="container">
        <div class="ps-page__header">
            <h1><?php echo e(SeoHelper::getTitle()); ?></h1>
        </div>
        <div><?php echo Theme::content(); ?></div>
        <div class="ps-page__footer">
            <ul class="ps-list--social">
                <?php for($i = 1; $i <= 5; $i++): ?>
                    <?php if(theme_option('social-name-' . $i) && theme_option('social-url-' . $i) && theme_option('social-icon-' . $i)): ?>
                        <li>
                            <a href="<?php echo e(theme_option('social-url-' . $i)); ?>"
                               title="<?php echo e(theme_option('social-name-' . $i)); ?>" style="color: <?php echo e(theme_option('social-color-' . $i)); ?>">
                                <i class="fa <?php echo e(theme_option('social-icon-' . $i)); ?>"></i>
                            </a>
                        </li>
                    <?php endif; ?>
                <?php endfor; ?>
            </ul>
        </div>
    </div>
</div>

<?php echo Theme::footer(); ?>

</body>
</html>

<?php /**PATH /home/baronmac/shop.baronmachinesint.one/platform/themes/martfury/layouts/coming-soon.blade.php ENDPATH**/ ?>