<?php $__env->startSection('content'); ?>
    <?php echo Form::open(['url' => route('ecommerce.tracking-settings'), 'class' => 'main-setting-form']); ?>

        <div class="max-width-1200">

            <div class="flexbox-annotated-section">
                <div class="flexbox-annotated-section-annotation">
                    <div class="annotated-section-title pd-all-20">
                        <h2><?php echo e(trans('plugins/ecommerce::ecommerce.setting.tracking_settings')); ?></h2>
                    </div>
                    <div class="annotated-section-description pd-all-20 p-none-t">
                        <p class="color-note"><?php echo e(trans('plugins/ecommerce::ecommerce.setting.tracking_settings_description')); ?></p>
                    </div>
                </div>
                <div class="flexbox-annotated-section-content">
                    <div class="wrapper-content pd-all-20">
                        <div class="form-group mb-3">
                            <label class="text-title-field"
                                   for="facebook_pixel_enabled"><?php echo e(trans('plugins/ecommerce::ecommerce.setting.enable_facebook_pixel')); ?>

                            </label>
                            <label class="me-2">
                                <input type="radio" name="facebook_pixel_enabled"
                                       value="1"
                                       class="trigger-input-option" data-setting-container=".facebook-pixel-settings-container"
                                       <?php if(EcommerceHelper::isFacebookPixelEnabled()): ?> checked <?php endif; ?>><?php echo e(trans('core/setting::setting.general.yes')); ?>

                            </label>
                            <label>
                                <input type="radio" name="facebook_pixel_enabled"
                                       value="0"
                                       class="trigger-input-option" data-setting-container=".facebook-pixel-settings-container"
                                       <?php if(!EcommerceHelper::isFacebookPixelEnabled()): ?> checked <?php endif; ?>><?php echo e(trans('core/setting::setting.general.no')); ?>

                            </label>
                        </div>

                        <?php echo Form::helper(trans('plugins/ecommerce::ecommerce.setting.facebook_pixel_helper')); ?>


                        <div class="facebook-pixel-settings-container mb-4 border rounded-top rounded-bottom p-3 bg-light <?php if(!EcommerceHelper::isFacebookPixelEnabled()): ?> d-none <?php endif; ?>">
                            <div class="form-group mb-3">
                                <label class="text-title-field"
                                       for="facebook_pixel_id"><?php echo e(trans('plugins/ecommerce::ecommerce.setting.facebook_pixel_id')); ?>

                                </label>
                                <input type="text" name="facebook_pixel_id" class="next-input" value="<?php echo e(get_ecommerce_setting('facebook_pixel_id')); ?>">
                            </div>
                        </div>

                        <div class="form-group mb-3">
                            <label class="text-title-field"
                                   for="google_tag_manager_enabled"><?php echo e(trans('plugins/ecommerce::ecommerce.setting.enable_google_tag_manager')); ?>

                            </label>
                            <label class="me-2">
                                <input type="radio" name="google_tag_manager_enabled"
                                       value="1"
                                       class="trigger-input-option" data-setting-container=".google-tag-manager-settings-container"
                                       <?php if(EcommerceHelper::isGoogleTagManagerEnabled()): ?> checked <?php endif; ?>><?php echo e(trans('core/setting::setting.general.yes')); ?>

                            </label>
                            <label>
                                <input type="radio" name="google_tag_manager_enabled"
                                       value="0"
                                       class="trigger-input-option" data-setting-container=".google-tag-manager-settings-container"
                                       <?php if(!EcommerceHelper::isGoogleTagManagerEnabled()): ?> checked <?php endif; ?>><?php echo e(trans('core/setting::setting.general.no')); ?>

                            </label>
                        </div>

                        <?php echo Form::helper(trans('plugins/ecommerce::ecommerce.setting.google_tag_manager_helper')); ?>


                        <div class="google-tag-manager-settings-container mb-4 border rounded-top rounded-bottom p-3 bg-light <?php if(!EcommerceHelper::isGoogleTagManagerEnabled()): ?> d-none <?php endif; ?>">
                            <div class="form-group mb-3">
                                <label class="text-title-field mb-2"
                                       for="google_tag_manager_id"><?php echo e(trans('plugins/ecommerce::ecommerce.setting.google_tag_manager_code')); ?>

                                </label>
                                <textarea rows="3" name="google_tag_manager_code" id="google_tag_manager_code" class="next-input"><?php echo e(get_ecommerce_setting('google_tag_manager_code')); ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="flexbox-annotated-section" style="border: none">
                <div class="flexbox-annotated-section-annotation">
                    &nbsp;
                </div>
                <div class="flexbox-annotated-section-content">
                    <button class="btn btn-info" type="submit"><?php echo e(trans('plugins/ecommerce::currency.save_settings')); ?></button>
                </div>
            </div>
        </div>
    <?php echo Form::close(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('footer'); ?>
    <script>
        $(document).ready(() => {
            'use strict';

            Botble.initCodeEditor('google_tag_manager_code', 'javascript');
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make(BaseHelper::getAdminMasterLayoutTemplate(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/baronmac/shop.baronmachinesint.one/platform/plugins/ecommerce//resources/views//settings/tracking-settings.blade.php ENDPATH**/ ?>