<div class="tab-pane" id="tab_payout_info">
    <div class="form-group">
        <div class="ps-form__content">
            <div class="form-group">
                <label for="bank_info_name"><?php echo e(__('Payment Method')); ?>:</label>
                <?php echo Form::customSelect('payout_payment_method', \Botble\Marketplace\Enums\PayoutPaymentMethodsEnum::labels(), $model->vendorInfo->payout_payment_method); ?>

            </div>

            <div id="payout-payment-bank_transfer" class="payout-payment-wrapper  <?php if(old('payout_payment_method', $model->vendorInfo->payout_payment_method ?: 'bank_transfer') != 'bank_transfer'): ?> d-none <?php endif; ?>">
                <div class="form-group">
                    <label for="bank_info_name"><?php echo e(__('Bank Name')); ?>:</label>
                    <input id="bank_info_name"
                           type="text"
                           class="form-control"
                           name="bank_info[name]"
                           placeholder="<?php echo e(__('Bank Name')); ?>"
                           value="<?php echo e(Arr::get($model->bank_info, 'name')); ?>">
                </div>
                <?php echo Form::error('bank_info[name]', $errors); ?>


                <div class="form-group">
                    <label for="bank_info_code"><?php echo e(__('Bank Code/IFSC')); ?>:</label>
                    <input id="bank_info_code"
                           type="text"
                           class="form-control"
                           name="bank_info[code]"
                           placeholder="<?php echo e(__('Bank Code/IFSC')); ?>"
                           value="<?php echo e(Arr::get($model->bank_info, 'code')); ?>">
                </div>
                <?php echo Form::error('bank_info[code]', $errors); ?>


                <div class="form-group">
                    <label for="bank_info_number"><?php echo e(__('Account Number')); ?>:</label>
                    <input id="bank_info_number"
                           type="text"
                           class="form-control"
                           placeholder="<?php echo e(__('Bank number')); ?>"
                           name="bank_info[number]"
                           value="<?php echo e(Arr::get($model->bank_info, 'number')); ?>">
                </div>
                <?php echo Form::error('bank_info[number]', $errors); ?>


                <div class="form-group">
                    <label for="bank_info_full_name"><?php echo e(__('Account Holder Name')); ?>:</label>
                    <input id="bank_info_full_name"
                           type="text"
                           class="form-control"
                           placeholder="<?php echo e(__('Full name')); ?>"
                           name="bank_info[full_name]"
                           value="<?php echo e(Arr::get($model->bank_info, 'full_name')); ?>">
                </div>
                <?php echo Form::error('bank_info[full_name]', $errors); ?>


                <div class="form-group">
                    <label for="bank_info_upi_id"><?php echo e(__('UPI ID')); ?>:</label>
                    <input id="bank_info_upi_id"
                           type="text"
                           class="form-control"
                           placeholder="<?php echo e(__('UPI ID')); ?>"
                           name="bank_info[upi_id]"
                           value="<?php echo e(Arr::get($model->bank_info, 'upi_id')); ?>">
                </div>
                <?php echo Form::error('bank_info[upi_id]', $errors); ?>


                <div class="form-group">
                    <label for="bank_info_description"><?php echo e(__('Description')); ?>:</label>
                    <textarea id="bank_info_description"
                              type="text"
                              class="form-control"
                              placeholder="<?php echo e(__('Description')); ?>"
                              name="bank_info[description]"
                              rows="4"><?php echo e(Arr::get($model->bank_info, 'description')); ?></textarea>
                </div>
                <?php echo Form::error('bank_info[description]', $errors); ?>

            </div>

            <div id="payout-payment-paypal" class="payout-payment-wrapper <?php if(old('payout_payment_method', $model->vendorInfo->payout_payment_method ?: 'bank_transfer') != 'paypal'): ?> d-none <?php endif; ?>">
                <div class="form-group">
                    <label for="bank_info_paypal_id"><?php echo e(__('PayPal Email ID')); ?>:</label>
                    <input id="bank_info_paypal_id"
                           type="text"
                           class="form-control"
                           placeholder="<?php echo e(__('PayPal Email ID')); ?>"
                           name="bank_info[paypal_id]"
                           value="<?php echo e(Arr::get($model->bank_info, 'paypal_id')); ?>">
                </div>
                <?php echo Form::error('bank_info[paypal_id]', $errors); ?>

            </div>

        </div>
    </div>
</div>

<script>
    'use strict';

    $(document).ready(function () {
        $(document).on('change', 'select[name="payout_payment_method"]', function () {
            $('.payout-payment-wrapper').addClass('d-none');
            $('#payout-payment-' + $(this).val()).removeClass('d-none');
        });
    });
</script>
<?php /**PATH /home/baronmac/shop.baronmachinesint.one/platform/plugins/marketplace//resources/views//customers/payout-form.blade.php ENDPATH**/ ?>